<?php
require_once "../function.php";

$kode = $_GET["kode_pesanan"] ?? '';
$pembayaran = (int) ($_GET["pembayaran"] ?? 0);

$menu = ambil_data("
    SELECT pesanan.qty, menu.nama, menu.harga,
           transaksi.nama_pelanggan, transaksi.waktu
    FROM pesanan
    JOIN menu ON menu.kode_menu = pesanan.kode_menu
    JOIN transaksi ON transaksi.kode_pesanan = pesanan.kode_pesanan
    WHERE pesanan.kode_pesanan = '$kode'
");

if (count($menu) == 0) {
    echo "Data tidak ditemukan";
    exit;
}

$total = 0;
foreach ($menu as $m) {
    $total += $m["qty"] * $m["harga"];
}

if ($pembayaran >= $total) {
    mysqli_query($koneksi, "
        UPDATE transaksi 
        SET status = 'LUNAS'
        WHERE kode_pesanan = '$kode'
    ");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Struk - <?= htmlspecialchars($menu[0]['nama_pelanggan']); ?></title>
<style>
    body {
        font-family: monospace;
        font-size: 12px;
        width: 280px;
        margin: auto;
        line-height: 1.5;
    }
    .center { text-align: center; }
    .right { text-align: right; }
    .line { border-top: 1px dashed #000; margin: 10px 0; }
    table { width: 100%; border-collapse: collapse; }
    td { padding: 3px 0; vertical-align: top; }
    .item-name { font-weight: bold; padding-top: 3px; }
    .footer { margin-top: 12px; text-align: center; font-size: 11px; }
    @media print { button { display: none; } }
</style>
</head>
<body onload="window.print()">

<div class="center">
    <strong>WARKOP ABANG PUTEH</strong><br>
    Baleono, Sendang, Kec.Senori, Kab. Tuban Jawa timur<br>
    Telp: +62 852 3016 6698
</div>

<div class="line"></div>

<table>
    <tr>
        <td>Kode</td>
        <td class="right"><?= htmlspecialchars($kode); ?></td>
    </tr>
    <tr>
        <td>Nama Pelanggan</td>
        <td class="right"><?= htmlspecialchars($menu[0]["nama_pelanggan"]); ?></td>
    </tr>
    <tr>
        <td>Waktu</td>
        <td class="right"><?= $menu[0]["waktu"]; ?></td>
    </tr>
</table>

<div class="line"></div>

<!-- DAFTAR MENU -->
<table>
<?php foreach ($menu as $m): 
    $subtotal = $m["qty"] * $m["harga"];
?>
    <tr>
        <td colspan="2" class="item-name"><?= htmlspecialchars($m["nama"]); ?></td>
    </tr>
    <tr>
        <td><?= $m["qty"]; ?> x Rp <?= number_format($m["harga"],0,',','.'); ?></td>
        <td class="right">Rp <?= number_format($subtotal,0,',','.'); ?></td>
    </tr>
<?php endforeach; ?>
</table>

<div class="line"></div>

<table>
    <tr>
        <td><strong>Total</strong></td>
        <td class="right"><strong>Rp <?= number_format($total,0,',','.'); ?></strong></td>
    </tr>
<?php if ($pembayaran >= $total): ?>
    <tr>
        <td>Bayar</td>
        <td class="right">Rp <?= number_format($pembayaran,0,',','.'); ?></td>
    </tr>
    <tr>
        <td>Kembali</td>
        <td class="right">Rp <?= number_format($pembayaran - $total,0,',','.'); ?></td>
    </tr>
<?php else: ?>
    <tr>
        <td colspan="2" class="right"><strong>Pembayaran Kurang</strong></td>
    </tr>
<?php endif; ?>
</table>

<div class="line"></div>

<div class="footer">
    Terima kasih atas kunjungan Anda<br>
    Selamat menikmati!
</div>

</body>
</html>
