<?php
session_start();
require_once "function.php";

if (!isset($_SESSION["akun-admin"])) {
    if (isset($_SESSION["akun-user"])) {
        echo "<script>
            alert('Edit data hanya berlaku untuk admin!');
            location.href = 'index.php';
        </script>";
        exit;
    } else {
        header("Location: login.php");
        exit;
    }
}

if (isset($_POST["edit"])) {
    $edit = edit_data_menu();

    if ($edit > 0) {
        echo "<script>
            alert('Data berhasil diubah!');
            location.href = 'index.php';
        </script>";
    } elseif ($edit == 0) {
        echo "<script>
            alert('Data tidak ada yang diubah!');
            location.href = 'index.php';
        </script>";
    } else {
        echo "<script>
            alert('Data gagal diubah!');
            location.href = 'index.php';
        </script>";
    }
}

$id_menu = $_GET["id_menu"];
$menu = ambil_data("SELECT * FROM menu WHERE id_menu = $id_menu")[0];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Menu</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">
</head>

<body class="bg-light">

<div class="container py-5">

    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">
            <i class="bi bi-pencil-square"></i> Edit Menu
        </h3>
        <a href="index.php" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Kembali
        </a>
    </div>

    <!-- CARD FORM -->
    <div class="card shadow-sm">
        <div class="card-body p-4">

            <form action="edit.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="id_menu" value="<?= $menu["id_menu"]; ?>">
                <input type="hidden" name="gambar-lama" value="<?= $menu["gambar"]; ?>">
                <input type="hidden" name="kode_menu" value="<?= $menu["kode_menu"]; ?>">

                <!-- NAMA -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Nama Menu</label>
                    <input type="text"
                           class="form-control"
                           name="nama"
                           value="<?= $menu["nama"]; ?>"
                           required>
                </div>

                <!-- HARGA -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Harga</label>
                    <div class="input-group">
                        <span class="input-group-text">Rp</span>
                        <input type="number"
                               class="form-control"
                               name="harga"
                               min="0"
                               value="<?= $menu["harga"]; ?>"
                               required>
                    </div>
                </div>

                <!-- GAMBAR -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Gambar Menu</label>
                    <div class="d-flex align-items-center gap-3">
                        <img src="src/img/<?= $menu["gambar"]; ?>"
                             class="rounded border"
                             width="90">
                        <input type="file"
                               class="form-control"
                               name="gambar"
                               accept="image/*">
                    </div>
                    <small class="text-muted">
                        Kosongkan jika tidak ingin mengganti gambar
                    </small>
                </div>

                <!-- KATEGORI -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Kategori</label>
                    <select name="kategori" class="form-select" required>
                        <?php
                        $kategori = ["Makanan", "Minuman", "Snack", "Lainya"];
                        foreach ($kategori as $k):
                        ?>
                        <option value="<?= $k; ?>" <?= $menu["kategori"] == $k ? "selected" : ""; ?>>
                            <?= $k; ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- STATUS -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Status</label>
                    <div class="d-flex gap-4">
                        <div class="form-check">
                            <input class="form-check-input"
                                   type="radio"
                                   name="status"
                                   value="tersedia"
                                   <?= $menu["status"] == "tersedia" ? "checked" : ""; ?>>
                            <label class="form-check-label">Tersedia</label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input"
                                   type="radio"
                                   name="status"
                                   value="tidak tersedia"
                                   <?= $menu["status"] == "tidak tersedia" ? "checked" : ""; ?>>
                            <label class="form-check-label">Tidak tersedia</label>
                        </div>
                    </div>
                </div>

                <!-- BUTTON -->
                <div class="d-flex justify-content-end gap-2">
                    <a href="index.php" class="btn btn-secondary">
                        Batal
                    </a>
                    <button type="submit" name="edit" class="btn btn-primary px-4">
                        <i class="bi bi-save"></i> Simpan Perubahan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>

<script src="./src/css/bootstrap-5.2.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>
