<?php
// TANPA session_start()
if (!isset($_SESSION["akun-admin"])) {
    header("Location: index.php");
    exit;
}


/* keamanan admin */
if (!isset($_SESSION["akun-admin"])) {
    header("Location: index.php");
    exit;
}

/* ambil data transaksi */
$menu = ambil_data("SELECT * FROM transaksi ORDER BY waktu DESC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Transaksi</title>

    <link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">
</head>

<body class="bg-light">

<div class="container mt-4">

<!-- TRANSAKSI -->
<div class="card shadow-sm">
    <div class="card-header bg-dark text-white fw-bold d-flex justify-content-between align-items-center">
        <span><i class="bi bi-cash-stack"></i> Transaksi Pembayaran</span>
        <span class="badge bg-secondary">Total: <?= count($menu); ?></span>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">No</th>
                        <th>Kode Pesanan</th>
                        <th>Nama Pelanggan</th>
                        <th>Waktu</th>
                        <th>Total</th>
                        <th class="text-center">Pembayaran</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>

                <tbody>
                <?php
                $i = 1;
                foreach ($menu as $m):
                    $kode_pesanan = $m["kode_pesanan"];

                    /* hitung total */
                    $detail = ambil_data("
                        SELECT pesanan.qty, menu.harga
                        FROM pesanan
                        JOIN menu ON menu.kode_menu = pesanan.kode_menu
                        WHERE pesanan.kode_pesanan = '$kode_pesanan'
                    ");

                    $total = 0;
                    foreach ($detail as $d) {
                        $total += $d["qty"] * $d["harga"];
                    }

                    $isLunas = ($m["status"] === "LUNAS");
                ?>

                <tr class="<?= $isLunas ? 'table-success' : ''; ?>">
                    <form action="cetak/cetak.php" target="_blank" method="GET">

                        <input type="hidden" name="kode_pesanan" value="<?= $kode_pesanan; ?>">

                        <td class="text-center"><?= $i; ?></td>
                        <td class="fw-bold"><?= $kode_pesanan; ?></td>
                        <td><?= $m["nama_pelanggan"]; ?></td>
                        <td><?= $m["waktu"]; ?></td>
                        <td>Rp <?= number_format($total, 0, ',', '.'); ?></td>

<!-- PEMBAYARAN (RUPIAH) -->
<td class="text-center" style="max-width:160px;">
    <input type="text"
           class="form-control form-control-sm pembayaran"
           placeholder="<?= $isLunas ? 'BAYAR ULANG' : 'BAYAR'; ?>"
           autocomplete="off">

    <!-- nilai asli untuk PHP -->
    <input type="hidden" name="pembayaran" class="pembayaran-asli">
</td>


                        <!-- STATUS -->
                        <td class="text-center">
                            <?php if ($isLunas): ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle"></i> LUNAS
                                </span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">
                                    <i class="bi bi-clock"></i> BELUM LUNAS
                                </span>
                            <?php endif; ?>
                        </td>

<!-- AKSI -->
<td class="text-center">
    <div class="d-flex justify-content-center align-items-center gap-1">
        <button class="btn btn-success btn-sm" title="Cetak Struk">
            <i class="bi bi-printer"></i>
        </button>

        <a class="btn btn-danger btn-sm"
           href="hapus.php?kode_pesanan=<?= $kode_pesanan; ?>"
           onclick="return confirm('Hapus transaksi ini?')">
            <i class="bi bi-trash"></i>
        </a>
    </div>
</td>


                    </form>
                </tr>

                <?php
                $i++;
                endforeach;
                ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</div>

<!-- FORMAT RUPIAH -->
<script>
document.querySelectorAll('.pembayaran').forEach(input => {
    input.addEventListener('input', function () {
        let angka = this.value.replace(/[^0-9]/g, '');
        let rupiah = new Intl.NumberFormat('id-ID').format(angka);
        this.value = rupiah;
        this.nextElementSibling.value = angka;
    });
});
</script>

</body>
</html>
