<?php
session_start();
require_once "function.php";

if (!isset($_SESSION["akun-admin"]) && !isset($_SESSION["akun-user"])) {
    header("Location: login.php");
    exit;
}

/* ================= DATA ================= */
if (isset($_GET["transaksi"])) {
    $menu = ambil_data("SELECT * FROM transaksi");
} elseif (isset($_GET["pesanan"])) {
    $menu = ambil_data("
        SELECT p.kode_pesanan, t.nama_pelanggan, p.kode_menu, p.qty
        FROM pesanan p
        JOIN transaksi t ON t.kode_pesanan = p.kode_pesanan
    ");
} else {
    $menu = ambil_data("SELECT * FROM menu ORDER BY kode_menu DESC");
}

/* ================= PESAN ================= */
if (isset($_POST["pesan"])) {
    $hasil = tambah_data_pesanan();

    $_SESSION["popup"] = [
        "type" => $hasil > 0 ? "success" : "error",
        "title" => $hasil > 0 ? "Pesanan Berhasil" : "Pesanan Gagal",
        "message" => $hasil > 0
            ? "Silahkan melakukan pembayaran secara langsung melalui Kasir"
            : "Terjadi kesalahan, silakan ulangi",
        "sound" => $hasil > 0
    ];

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
<link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<title>warkop Abang Puteh</title>

<style>
body { overflow-x: hidden; }

#sidebar {
    width: 220px;
    left: -220px;
    transition: .3s;
    z-index: 1029;
}

#sidebar a:hover {
    background:#495057;
    border-radius:6px;
}

.content { margin-top: 80px; }

/* popup animation */
.popup-animate {
    animation: zoomIn .4s ease;
}

@keyframes zoomIn {
    from { transform: scale(.8); opacity: 0; }
    to   { transform: scale(1); opacity: 1; }
}
.input-group button:active {
    transform: scale(0.9);
}
<button class="btn btn-outline-danger">−</button>
<button class="btn btn-outline-success">+</button>
.menu-card {
    transition: transform .2s ease, box-shadow .2s ease;
}
.menu-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 20px rgba(0,0,0,.15);
}
.glass-bar {
    background: rgba(255, 255, 255, 0.75);
    backdrop-filter: blur(12px);
    -webkit-backdrop-filter: blur(12px);
    border-radius: 14px;
    border: 1px solid rgba(255,255,255,0.4);
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}

.glass-bar .form-control {
    background: rgba(255,255,255,0.9);
}

.glass-bar .btn {
    white-space: nowrap;
}

</style>
</head>

<body class="bg-light">

<!-- ================= HEADER ================= -->
<div class="container-fluid position-fixed top-0 bg-dark px-4 py-2 d-flex justify-content-between align-items-center" style="z-index:1030;">
    <div class="text-white h4 d-flex align-items-center gap-3">
        <span id="menuBtn" role="button"><i class="bi bi-list fs-3"></i></span>
        <strong class="d-flex align-items-center gap-2">
    <i class="bi bi-cup-hot-fill text-warning"></i>
    Warkop Abang Puteh
</strong>

    </div>

    <div class="d-flex align-items-center gap-3">
        <span class="badge bg-secondary">
            <?= isset($_SESSION["akun-admin"]) ? "Kasir" : "Pembeli"; ?>
        </span>
        <button class="btn btn-danger btn-sm fw-bold" data-bs-toggle="modal" data-bs-target="#logoutModal">
            Logout
        </button>
    </div>
</div>

<!-- ================= SIDEBAR ================= -->
<div id="sidebar" class="position-fixed top-0 vh-100 text-white p-4" style="top:56px; width: 280px; left: -280px; transition: left 0.4s ease-in-out; background: linear-gradient(135deg, #8b1313ff 0%, #d21e1eff 50%, #a02d2dff 100%); box-shadow: 4px 0 10px rgba(0,0,0,0.2);">
    <h5 class="fw-bold mb-4 text-center" style="border-bottom: 2px solid rgba(255,255,255,0.3); padding-bottom: 10px;">
        <i class="bi bi-menu-button-wide-fill me-2"></i>Navigasi
    </h5>
    <ul class="nav flex-column gap-3">
        <li class="nav-item">
            <a class="nav-link text-white d-flex align-items-center gap-3 py-3 px-3 rounded-3 transition-all" href="index.php" style="transition: background-color 0.3s ease, transform 0.2s ease;">
                <i class="bi bi-grid-fill fs-5"></i>
                <span class="fw-medium">Menu Utama</span>
            </a>
        </li>
        <?php if (isset($_SESSION["akun-admin"])): ?>
        <li class="nav-item">
            <a class="nav-link text-white d-flex align-items-center gap-3 py-3 px-3 rounded-3 transition-all" href="index.php?pesanan" style="transition: background-color 0.3s ease, transform 0.2s ease;">
                <i class="bi bi-receipt fs-5"></i>
                <span class="fw-medium">Pesanan</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-white d-flex align-items-center gap-3 py-3 px-3 rounded-3 transition-all" href="index.php?transaksi" style="transition: background-color 0.3s ease, transform 0.2s ease;">
                <i class="bi bi-cash-stack fs-5"></i>
                <span class="fw-medium">Transaksi</span>
            </a>
        </li>
        <?php endif; ?>
    </ul>
    <div class="mt-auto pt-4">
        <p class="text-white-50 small text-center">©2026</p>
    </div>
</div>

<!-- ================= CONTENT ================= -->
<div class="container content">
<?php
if (isset($_GET["pesanan"])) {
    include "halaman/pesanan.php";
} elseif (isset($_GET["transaksi"])) {
    include "halaman/transaksi.php";
} else {
    include "halaman/beranda.php";
}
?>
</div>

<!-- ================= POPUP PESANAN ================= -->
<?php if (isset($_SESSION["popup"])): ?>
<div class="modal fade" id="popupPesan" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content popup-animate">
            <div class="modal-body text-center p-4">

                <i class="bi <?= $_SESSION["popup"]["type"] == "success"
                    ? "bi-check-circle-fill text-success"
                    : "bi-x-circle-fill text-danger"; ?> fs-1 mb-3"></i>

                <h4 class="fw-bold"><?= $_SESSION["popup"]["title"]; ?></h4>
                <p class="text-muted"><?= $_SESSION["popup"]["message"]; ?></p>

                <button class="btn btn-success px-4 mt-3" data-bs-dismiss="modal">
                    OK
                </button>
            </div>
        </div>
    </div>
</div>

<?php if ($_SESSION["popup"]["sound"]): ?>
<audio id="dingSound" src="src/sound/ding.mp3"></audio>
<?php endif; ?>

<?php unset($_SESSION["popup"]); endif; ?>

<!-- ================= LOGOUT MODAL ================= -->
<div class="modal fade" id="logoutModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content popup-animate">
            <div class="modal-body text-center p-4">
                <i class="bi bi-box-arrow-right text-danger fs-1 mb-3"></i>
                <h4 class="fw-bold">Konfirmasi Logout</h4>
                <p class="text-muted">Apakah kamu yakin ingin keluar?</p>

                <div class="d-flex justify-content-center gap-3 mt-4">
                    <button class="btn btn-secondary px-4" data-bs-dismiss="modal">Batal</button>
                    <a href="logout.php" class="btn btn-danger px-4">Logout</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ================= SCRIPT ================= -->
<script src="./src/css/bootstrap-5.2.0/js/bootstrap.min.js"></script>

<script>

/* ================= SIDEBAR ================= */
const menuBtn = document.getElementById("menuBtn");
const sidebar = document.getElementById("sidebar");
let open = false;

if (menuBtn && sidebar) {
    menuBtn.onclick = () => {
        sidebar.style.left = open ? "-280px" : "0";
        open = !open;
    };
}

/* ================= POPUP + SOUND ================= */
document.addEventListener("DOMContentLoaded", () => {
    const popup = document.getElementById("popupPesan");
    if (popup) {
        new bootstrap.Modal(popup).show();

        const sound = document.getElementById("dingSound");
        if (sound) sound.play();
    }
});
function spinnerQty(id, change) {
    const input = document.getElementById(id);
    if (!input) return;

    let value = parseInt(input.value) || 0;
    value += change;

    if (value < 0) value = 0;

    input.value = value;
}

</script>


</body>
</html>
