<?php
session_start();
require_once "function.php";

/* ================= CEK AKSES ================= */
if (!isset($_SESSION["akun-admin"])) {
    if (isset($_SESSION["akun-user"])) {
        echo "<script>
            alert('Tambah data hanya berlaku untuk admin!');
            location.href = 'index.php';
        </script>";
        exit;
    } else {
        header("Location: login.php");
        exit;
    }
}

/* ================= PROSES TAMBAH ================= */
if (isset($_POST["tambah"])) {
    $tambah = tambah_data_menu();

    echo $tambah > 0
        ? "<script>alert('Data berhasil ditambahkan!'); location.href='index.php';</script>"
        : "<script>alert('Data gagal ditambahkan!');</script>";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Tambah Menu | Warkop Abang Puteh</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
<link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">

<style>
body {
    background: #f1f3f5;
}
.form-card {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
    padding: 35px;
    animation: fadeUp .4s ease;
}
@keyframes fadeUp {
    from { opacity: 0; transform: translateY(20px); }
    to   { opacity: 1; transform: translateY(0); }
}
</style>
</head>

<body>

<div class="container mt-5 mb-5" style="max-width:720px;">
<div class="form-card">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="fw-bold mb-0">
        <i class="bi bi-cup-hot-fill text-warning"></i>
        Tambah Menu Warkop
    </h4>
    <a href="index.php" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>
</div>

<!-- FORM -->
<form action="" method="POST" enctype="multipart/form-data">

    <!-- NAMA -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Nama Menu</label>
        <input type="text"
               name="nama"
               class="form-control"
               placeholder="Contoh: Kopi Hitam"
               autocomplete="off"
               required>
    </div>

    <!-- HARGA RUPIAH -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Harga</label>

        <div class="input-group">
            <span class="input-group-text">Rp</span>
            <input type="text"
                   id="harga_display"
                   class="form-control"
                   placeholder="0"
                   autocomplete="off"
                   required>
        </div>

        <!-- nilai asli untuk PHP -->
        <input type="hidden" name="harga" id="harga_real">
    </div>

    <!-- GAMBAR -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Gambar Menu</label>
        <input type="file"
               name="gambar"
               class="form-control"
               accept="image/*"
               required>
    </div>

    <!-- KATEGORI -->
    <div class="mb-3">
        <label class="form-label fw-semibold">Kategori</label>
        <select name="kategori" class="form-select" required>
            <option value="Makanan">Makanan</option>
            <option value="Minuman">Minuman</option>
            <option value="Snack">Snack</option>
            <option value="Lainya">Lainya</option>
        </select>
    </div>

    <!-- STATUS -->
    <div class="mb-4">
        <label class="form-label fw-semibold">Status</label>
        <div class="d-flex gap-4">
            <div class="form-check">
                <input class="form-check-input"
                       type="radio"
                       name="status"
                       value="tersedia"
                       checked>
                <label class="form-check-label">Tersedia</label>
            </div>
            <div class="form-check">
                <input class="form-check-input"
                       type="radio"
                       name="status"
                       value="tidak tersedia">
                <label class="form-check-label">Tidak tersedia</label>
            </div>
        </div>
    </div>

    <!-- SUBMIT -->
    <div class="d-flex justify-content-end">
        <button type="submit"
                name="tambah"
                class="btn btn-success fw-bold px-4">
            <i class="bi bi-save"></i> Simpan Menu
        </button>
    </div>

</form>
</div>
</div>

<script src="./src/css/bootstrap-5.2.0/js/bootstrap.bundle.min.js"></script>

<script>
/* ================= FORMAT RUPIAH ================= */
const hargaDisplay = document.getElementById("harga_display");
const hargaReal    = document.getElementById("harga_real");

hargaDisplay.addEventListener("input", function () {
    let value = this.value.replace(/\D/g, "");
    hargaReal.value = value;
    this.value = value.replace(/\B(?=(\d{3})+(?!\d))/g, ".");
});
</script>

</body>
</html>
